<?php
/* --------------------------------------------------------------
   InvalidArgumentException.php 2020-04-23
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Cache\Exceptions;

use Exception;
use Psr\SimpleCache\InvalidArgumentException as InvalidArgumentExceptionInterface;

/**
 * Class InvalidArgumentException
 *
 * @package Gambio\Core\Cache\Exceptions
 */
class InvalidArgumentException extends Exception implements InvalidArgumentExceptionInterface
{
    /**
     * @return static
     */
    public static function forKey(): self
    {
        return new self('Provided key is invalid. String must contain only these characters: a-z, A-Z, 0-9, _ or .');
    }
    
    
    /**
     * @return static
     */
    public static function forNamespace(): self
    {
        return new self('Provided namespace is invalid. String must contain only these characters: a-z, A-Z, 0-9, _ or .');
    }
}